<?php 
/*
    Template Name: ACTUALITES
*/
get_header();
?>
<!------- Begin Page Content ------->
<div Class="content h2vert-actualite ">
    <div class="about-page-1">
        <div class="container">
            <div class="title-actualite">
                <h1><?php the_field( 'grand_titre' ); ?></h1>
            </div>
            <div class="subtitle-actualite">
                <p><?php the_field( 'sous_titre' ); ?></p>
            </div>
            <div class="scroll">
                <a href="#actualite-1">
                    <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/image/Groupe 571.svg" alt="">
                </a>
            </div>
        </div>
    </div>
    <section class="actualite" style="background-color: #FFF; margin-top: 0;padding: 0 0;" id="actualite-1">
        <div class="container">
            <div class="btns-news">
            <?php
            // Outputting the "All" button with the active class by default
            echo '<a href="#" class="category-link active-news" data-category="">All</a>';

            // Retrieving categories and outputting them
            $categories = get_terms(array('taxonomy' => 'categorie_actualites', 'hide_empty' => false));

            if (!empty($categories) && !is_wp_error($categories)) {
                foreach ($categories as $category) { 

                    echo '<a  href="#" class="category-link" data-category="' . esc_attr($category->slug) . '">' . esc_html($category->name) . '</a>';
                }
            } else {
                echo '<p>No categories found</p>';
            }
            ?>
            </div>
            <input type="hidden"  name="step" id="step" value="2">
            <input type="hidden"  name="category" id="category" value="">
            <div id="container_article">
            </div>
        </div>
    </section>
    <!-- Show more button -->
    <div class="show-more-news">
        <span id="voir_plus">Voir plus</span> <img src="https://h2vert.evast-in.com/site/wp-content/themes/twentytwentyone/assets/image/row.svg" alt="">
    </div>
</div>
<?php 
get_footer();
?>