<?php 
/*
    Template Name: ACTUALITES AJAX
*/
$step = isset($_GET["step"]) ? $_GET["step"] : 1;
$posts_per_page = isset($_GET["posts_per_page"]) ? $_GET["posts_per_page"] : 10;
$category = isset($_GET["category"]) ? $_GET["category"] : "";
if ($category != "") 
{
    $args = array(
        'post_type'      => 'actualitees',
        'post_status'    => 'publish',
        'order'          => 'DESC',
        'tax_query'      => array(
            array (
                'taxonomy' => 'categorie_actualites',
                'field' => 'slug',
                'terms' => $category,
            )
        ),
        'posts_per_page' => $posts_per_page,
        'paged'          => $step
    );
}
else 
{
    $args = array(
        'post_type'      => 'actualitees',
        'post_status'    => 'publish',
        'order'          => 'DESC',
        'posts_per_page' => $posts_per_page,
        'paged'          => $step
    );
}
$loop = new WP_Query($args);
?>
<div class="container">
    <div class="row">
        <?php 
        $i=0;
        while ($loop->have_posts())
        {
            $i++;
            $loop->the_post();
            // Get the date
            $date_big = get_field('date');
            $date_timestamp_big = strtotime($date_big);
            $current_timestamp_big = current_time('timestamp');
            $time_difference_big = $current_timestamp_big - $date_timestamp_big;
            $days_difference_big = round($time_difference_big / (60 * 60 * 24));
            // Format the time difference for big news
            if ($days_difference_big == 1) {
                $time_ago_big = '1 day ago';
            } else {
                $time_ago_big = $days_difference_big . ' days ago';
            }
            // Get the category name
            $categories = get_the_terms(get_the_ID(), 'categorie_actualites');
            $category_name = '';
            if (!empty($categories)) {
                $category_name = $categories[0]->name;
            }
            if($i==1) // 1er cas div 8
            {
                ?> 
                <div class="col-md-8">
                    <div class="item-news-big">
                        <a href="<?php the_permalink(); ?>">
                        <div class="item-news-big-img">
                        <?php if ( get_field( 'image_slide' ) ) : ?>
                            <img src="<?php the_field( 'image_slide' ); ?>" width="100%"/>
                        <?php endif ?>
                            <div class="text-overlay">
                                <div class="category">
                                    <li><?php echo $category_name; ?></li>
                                </div>
                                <div class="title-item-news-big">
                                    <h3><?php the_title() ?></h3>
                                </div>
                                <div class="text-item-news-big">
                                    <span><?php the_field('description'); ?></span>
                                </div>
                                <div class="date-item-news-big">
                                    <span><?php echo $time_ago_big; ?></span>
                                </div>
                            </div>
                        </div>
                        </a>
                    </div>
                </div>
                <?php
            }
            if($i==2) // 2er cas div 4
            {
                ?>  
                <div class="col-md-4">
                    <div class="item-news-small">            
                        <a href="<?php the_permalink(); ?>">
                            <div class="img-item-news-small">
                            <?php if ( get_field( 'image_petite' ) ) : ?>
                                <img src="<?php the_field( 'image_petite' ); ?>"  width="100%"/>
                            <?php endif ?>
                            </div>
                            <div class="category">
                                <li><?php echo $category_name; ?></li>
                            </div>
                            <div class="title-item-news-small">
                                <h3><?php the_title() ?></h3>
                            </div>
                            <div class="date-item-news-small">
                                <span><?php echo $time_ago_big; ?></span>
                            </div>
                        </a>
                    </div>
                </div>
                <?php
            }
            if($i==3) // 3er cas div 4 fermeture de row / ouverture de row
            {
                ?>
                </div><div class="row">
                <div class="col-md-4">
                    <div class="item-news-small">            
                        <a href="<?php the_permalink(); ?>">
                            <div class="img-item-news-small">
                            <?php if ( get_field( 'image_petite' ) ) : ?>
                                <img src="<?php the_field( 'image_petite' ); ?>"  width="100%"/>
                            <?php endif ?>
                            </div>
                            <div class="category">
                                <li><?php echo $category_name; ?></li>
                            </div>
                            <div class="title-item-news-small">
                                <h3><?php the_title() ?></h3>
                            </div>
                            <div class="date-item-news-small">
                                <span><?php echo $time_ago_big; ?></span>
                            </div>
                        </a>
                    </div>
                </div>
                <?php  
            }
            if($i==4 || $i==5)  // 4er cas et 5eme cas div 4 
            {
                ?>  
                <div class="col-md-4">
                    <div class="item-news-small">            
                        <a href="<?php the_permalink(); ?>">
                            <div class="img-item-news-small">
                            <?php if ( get_field( 'image_petite' ) ) : ?>
                                <img src="<?php the_field( 'image_petite' ); ?>"  width="100%"/>
                            <?php endif ?>
                            </div>
                            <div class="category">
                                <li><?php echo $category_name; ?></li>
                            </div>
                            <div class="title-item-news-small">
                                <h3><?php the_title() ?></h3>
                            </div>
                            <div class="date-item-news-small">
                                <span><?php echo $time_ago_big; ?></span>
                            </div>
                        </a>
                    </div>
                </div>
                <?php
            }
            if($i==6)  // 6er cas div 4 
            {
                ?>
                </div><div class="row"> 
                <div class="col-md-4">
                    <div class="item-news-small">            
                        <a href="<?php the_permalink(); ?>">
                            <div class="img-item-news-small">
                            <?php if ( get_field( 'image_petite' ) ) : ?>
                                <img src="<?php the_field( 'image_petite' ); ?>"  width="100%"/>
                            <?php endif ?>
                            </div>
                            <div class="category">
                                <li><?php echo $category_name; ?></li>
                            </div>
                            <div class="title-item-news-small">
                                <h3><?php the_title() ?></h3>
                            </div>
                            <div class="date-item-news-small">
                                <span><?php echo $time_ago_big; ?></span>
                            </div>
                        </a>
                    </div>
                </div>
                <?php 
            }
            if($i==7)  // 7er cas  div 8
            {
                ?> 
                <div class="col-md-8">
                    <div class="item-news-big">
                        <a href="<?php the_permalink(); ?>">
                        <div class="item-news-big-img">
                        <?php if ( get_field( 'image_slide' ) ) : ?>
                            <img src="<?php the_field( 'image_slide' ); ?>" width="100%"/>
                        <?php endif ?>
                            <div class="text-overlay">
                                <div class="category">
                                    <li><?php echo $category_name; ?></li>
                                </div>
                                <div class="title-item-news-big">
                                    <h3><?php the_title() ?></h3>
                                </div>
                                <div class="text-item-news-big">
                                    <span><?php the_field('description'); ?></span>
                                </div>
                                <div class="date-item-news-big">
                                    <span><?php echo $time_ago_big; ?></span>
                                </div>
                            </div>
                        </div>
                        </a>
                    </div>
                </div>
                <?php
            }
            if($i==8)  // 7er cas  div 4
            {
                ?>
                </div><div class="row"> 
                <div class="col-md-4">
                    <div class="item-news-small">            
                        <a href="<?php the_permalink(); ?>">
                            <div class="img-item-news-small">
                            <?php if ( get_field( 'image_petite' ) ) : ?>
                                <img src="<?php the_field( 'image_petite' ); ?>"  width="100%"/>
                            <?php endif ?>
                            </div>
                            <div class="category">
                                <li><?php echo $category_name; ?></li>
                            </div>
                            <div class="title-item-news-small">
                                <h3><?php the_title() ?></h3>
                            </div>
                            <div class="date-item-news-small">
                                <span><?php echo $time_ago_big; ?></span>
                            </div>
                        </a>
                    </div>
                </div>
                <?php
            }
            if($i==9 || $i==10)  // 4er cas et 5eme cas div 4 
            {
                ?>  
                <div class="col-md-4">
                    <div class="item-news-small">            
                        <a href="<?php the_permalink(); ?>">
                            <div class="img-item-news-small">
                            <?php if ( get_field( 'image_petite' ) ) : ?>
                                <img src="<?php the_field( 'image_petite' ); ?>"  width="100%"/>
                            <?php endif ?>
                            </div>
                            <div class="category">
                                <li><?php echo $category_name; ?></li>
                            </div>
                            <div class="title-item-news-small">
                                <h3><?php the_title() ?></h3>
                            </div>
                            <div class="date-item-news-small">
                                <span><?php echo $time_ago_big; ?></span>
                            </div>
                        </a>
                    </div>
                </div>
                <?php
            }
        }
        ?>
        <?php wp_reset_postdata();  ?>
    </div>
</div>
