jQuery(document).ready(function($) {
    var currentPage = 1; // Initialize current page number
    var totalPages = 1; // Initialize total number of pages
    var loading = false; // Flag to prevent multiple AJAX requests
    
    // Function to fetch posts via AJAX
    function loadPosts(category, page) {
        if (!loading) {
            loading = true;

            $.ajax({
                url: ajax_params.ajax_url,
                type: 'post',
                data: {
                    action: 'load_posts',
                    page: page,
                    category: category
                },
                success: function(response) {
                    $('.posts-container').html(response);
                    currentPage = page;
                    loading = false;
                }
            });
        }
    }

    // Load posts when page is loaded
    loadPosts('', currentPage);

    // Load posts when category is clicked
    $(document).on('click', '.category-link', function(e) {
        e.preventDefault();
        var category = $(this).data('category');
        loadPosts(category, 1);
    });

    // Load more posts when "Show more" button is clicked
    $(document).on('click', '.show-more-news a', function(e) {
        e.preventDefault();
        loadMorePosts();
    });

    // Function to load more posts via AJAX
    function loadMorePosts() {
        if (!loading && currentPage < totalPages) {
            loading = true;

            $.ajax({
                url: ajax_params.ajax_url,
                type: 'post',
                data: {
                    action: 'load_more_posts',
                    page: currentPage + 1,
                    category: $('.category-link.active-news').data('category')
                },
                success: function(response) {
                    $('.posts-container').append(response);
                    currentPage++;
                    updatePagination();
                    loading = false;
                }
            });
        }
    }

    // Update pagination links
    function updatePagination() {
        $('.pagination').html('');
        for (var i = 1; i <= totalPages; i++) {
            var linkClass = (i === currentPage) ? 'active' : '';
            $('.pagination').append('<a href="#" class="' + linkClass + '">' + i + '</a>');
        }
    }
});
