<?php 
/*
    Template Name: CONTACT
*/
get_header();
?>

<!------- Begin Page Content ------->
<div Class="content h2vert-about">
    <div class="about-page-1">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="title-about-page-1">
                        <h1><?php the_field( 'titre_' ); ?></h1>
                        <div class="item-content">
                            <a href="<?php the_field( 'lien_bouton' ); ?>" class="item-btn"><?php the_field( 'texte_bouton' ); ?> </a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 contact-img">
                    <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/image/Elect (svg).svg" alt="">
                </div>
            </div>

        </div>
    </div>
    <section class="contact-section-1">
        <div class="container">
            <div class="title-contact"><?php the_field( 'texte_formulaire' ); ?></div>
            <div class="subtitle-contact"><?php the_field( 'sous_texte_formulaire' ); ?></div>
            <?php
           echo do_shortcode('[contact-form-7 id="478edfe" title="Formulaire de contact 1"]') ?>
        </div>
    </section>


    <section class="contact-section-2">
        <div class="container">
            <div class="title-contact"><?php the_field( 'titre_contact' ); ?></div>
            <div class="info-h2vrt">
                <div class="social-links">
                    <ul class="social-icon-contact">
                        <li><a href="<?php the_field( 'lien_1' ); ?>"><i class="fa-brands fa-x-twitter"></i></a></li>
                        <li><a href="<?php the_field( 'lien_2' ); ?>"><i class="fa-brands fa-facebook-f" aria-hidden="true"></i></a></li>
                    </ul>
                </div>
                <div class="company-info">
                    <ul>
                        <li class="tel"> <a href="tel:<?php the_field( 'numero_de_telephone' ); ?>"><?php the_field( 'numero_de_telephone' ); ?></a> </li>
                        <li class="mail"> <a href="mailto:<?php the_field( 'email' ); ?>"><?php the_field( 'email' ); ?></a></li>
                        <li class="p-adress"> <a href="#"><?php the_field( 'adresse' ); ?></a> </li>
                    </ul>
                </div>
            </div>


        </div>
    </section>

    <section class="contact-section-3">
        <div class="container">
            <div class="presentation">
                <div class="holder-title">
                    <h2><?php the_field( 'titre_act' ); ?></h2>
                    <div class="show-more">
                        <a href="">
                            <span><?php the_field( 'texte_lien' ); ?></span>
                            <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/image/arrow.svg"
                                alt="Show more" width="45px">
                        </a>
                    </div>
                </div>
            </div>
            <div class="owl-carousel contact-carousel">
            <?php
            $args = array(
                'post_type'      => 'actualitees',
                'post_status'    => 'publish',
                'order'          => 'ASC',
                'posts_per_page' => -1 // retrieve all posts
            );

            $loop = new WP_Query($args);
            $count = 0; // Initialize counter

            while ($loop->have_posts()) : $loop->the_post();
                $count++; // Increment counter
            ?>
                <div class="item <?php echo ($count % 3 == 0) ? 'colored-item' : ''; ?>"> <!-- Add the 'colored-item' class every third item -->
                    <div class="card">
                    <?php if ( get_field( 'image_petite' ) ) : ?>
                                <img src="<?php the_field( 'image_petite' ); ?>"  width="100%" class="card-img-top"/>
                            <?php endif ?>
                        <div class="card-body">
                            <h5 class="card-title"><?php the_title() ?></h5>
                            <p class="card-text"><?php the_field('description'); ?> </p>
                            <a href="<?php the_permalink(); ?>" class="btn">Read all</a>
                        </div>
                    </div>
                </div>
            <?php endwhile;
            wp_reset_query();
            ?>
        </div>
    </div>
    </section>





    <!------- End Page Content ------->
<!------- Begin Footer------->
<footer class="footer">
    <div class="container-fluid">
        <section class="bloc-investir">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <h2>Vous cherchez</br> à investir ?</h2>
                        <p>Tenez-nous au courant et nous </br>prendrons contact avec vous dans</br> les plus brefs
                            délais.
                        </p>
                        <a href="<?php echo home_url()?>/investir" class="classic-btn">J’investis</a>
                    </div>
                    <div class="col-md-6">
                        <div class="bg-linear-investir">
                            <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/image/Statistique (jp).svg"
                                alt="" width="100%">
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="newsletter">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <h2>Abonnez-vous à </br> notre newsletter</h2>
                    </div>
                    <div class="col-md-6">
                        <form action="">
                            <input type="text" placeholder="Votre adresse e-mail" name="mail" required
                                class="form-news"  oninput="changeColor(this)">
                            <input type="submit" value="Subscribe" class="classic-btn">
                        </form>
                    </div>
                </div>
            </div>
        </section>

        <section class="footer-bottom">
            <div class="container">
                <div class="row">
                    <div class="col-md-8">
                        <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/image/Groupe4875.svg"
                            alt="Logo h2vert">
                        <div class="company-info">
                            <p class="p-adress">Green Hydrogen Tunisia, l’énergie du futur</p>
                            <ul>
                                <li class="tel"><i class="fas fa-phone"></i> <a href="tel:21672548632">+ 216 72 548 632</a></li>
                                <li class="mail"><i class="fas fa-envelope"></i> <a href="mailto:info@h2vert.com">info@h2vert.com</a></li>
                            </ul>

                        </div>
                    </div>
                    <div class="col-md-2">
                        <ul class="list-footer">
                            <li><a href="<?php echo home_url()?>/faq">FAQ</a></li>
                            <li><a href="<?php echo home_url()?>/glossaire">Glossaire</a></li>
                            <li><a href="#">Work With US</a></li>
                            <li><a href="#">Terms & Conditions</a></li>
                            <li><a href="#">Press Enquiries</a></li>
                            <li><a href="#">Mentions légales</a></li>
                        </ul>
                    </div>
                    <div class="col-md-2">
                        <ul class="list-footer">
                            <li><a href="<?php echo home_url() ?>/a-propos">A propos</a></li>
                            <li><a href="<?php echo home_url() ?>/investir">Investir</a></li>
                            <li><a href="<?php echo home_url() ?>/actualites">Actualités</a></li>
                            <li><a href="<?php echo home_url() ?>/publications">Publications</a></li>
                            <li><a href="<?php echo home_url() ?>/ministere-tutelle">Ministère Tutelle</a></li>
                            <li><a href="#">Coopération Internationale</a></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="copyright">
                <div class="container">
                <ul class="social-icon">
                    <li><a href=""><i class="fa-brands fa-x-twitter"></i></a></li>
                    <li><a href=""><i class="fa-brands fa-facebook-f"></i></a></li>
                    <li><a href="">GREEN H2 TUNISIA</a></li>
                </ul>
                <!-- <p>Green Hydrogen Tunisia,l’énergie du futur</p> -->
            </div>
            </div>
        </section>
    </div>
</footer>
<!------- Begin Footer ------->


    </body>

    <script src="<?php echo get_stylesheet_directory_uri(); ?>/assets/bootstrap-5/js/bootstrap.min.js"></script>
    <script src="https://kit.fontawesome.com/24508cbe2c.js" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.0/jquery.min.js"
        integrity="sha512-3gJwYpMe3QewGELv8k/BX9vcqhryRdzRMxVfq6ngyWXwo03GFEzjsUm8Q7RZcHPHksttq7/GFoxjCVUjkjvPdw=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="<?php echo get_stylesheet_directory_uri(); ?>/assets/owlcarousel/owl.carousel.min.js"></script>
    <script src="<?php echo get_stylesheet_directory_uri(); ?>/assets/js/main.js"></script>
    <script>
    $(".option").click(function() {
        $(".option").removeClass("active");
        $(this).addClass("active");

    });
    </script>

    </html>