<?php
/**
 * The header.
 *
 * This is the template that displays all of the <head> section and everything up until main.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Twenty_One
 * @since Twenty Twenty-One 1.0
 */

?>
<!DOCTYPE html>
<html lang="en">

<head>
   <meta charset="UTF-8">
   <meta name="viewport" content="width=device-width, initial-scale=1.0">
   <link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/bootstrap-5/css/bootstrap.min.css">
   <link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/owlcarousel/assets/owl.carousel.min.css">
   <link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/owlcarousel/assets/owl.theme.default.min.css">
   <link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/css/style.css">
   <link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/css/responsive.css">
   <link rel="icon" href="<?php echo get_stylesheet_directory_uri(); ?>/assets/image/favicon.ico" type="image/x-icon">
   <link rel="preconnect" href="https://fonts.googleapis.com">
   <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
   <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,300;0,400;0,500;0,700;1,600&display=swap"
      rel="stylesheet">
   <title>Green H2 Tunisia</title>
</head>

<body>
   <!------- Begin Header ------->
   <header class="header" id="stickyHeader">
      <div class="top-header">
         <!-- <div class="top-header-search container">
            <form class="search">
               <input type="text" class="searchTerm" placeholder="Search">
               <button type="submit" class="searchButton">
                  <i class="fa fa-search"></i>
               </button>
            </form>
            <a href="#">
               <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/image/tunisie1.svg" width="100%" height="auto" alt="">
            </a>
         </div> -->
         <div class="top-header-search container">
    <form class="search" action="<?php echo esc_url( home_url( '/' ) ); ?>" method="get">
        <input type="text" class="searchTerm" name="s" placeholder="Search">
        <button type="submit" class="searchButton">
            <i class="fa fa-search" aria-hidden="true"></i>
        </button>
    </form>
    <a href="#">
        <img src="https://h2vert.evast-in.com/site/wp-content/themes/twentytwentyone/assets/image/tunisie1.svg" width="100%" height="auto" alt="">
    </a>
</div>

         <nav class="navbar navbar-expand-lg navbar-light">
    <div class="container">
        <a class="navbar-brand" href="<?php echo home_url() ?>/landing">
            <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/image/greenH2-2.png" alt="">
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
            data-bs-target="#navbarNavAltMarkup" aria-controls="navbarNavAltMarkup" aria-expanded="false"
            aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNavAltMarkup">
            <div class="navbar-nav">
                <?php
                // Output each menu item
                $menu_items = wp_get_nav_menu_items('primary-menu');
                foreach ($menu_items as $menu_item) {
                    $class = 'nav-link';
                    if ($menu_item->menu_item_parent == 0) {
                        if (is_page($menu_item->object_id)) {
                            $class .= ' active';
                        }
                        // Check if the menu item has sub-menu items
                        if (has_children($menu_items, $menu_item->ID)) {
                            echo '<div class="dropdown">';
                            echo '<a class="nav-link dropdown-toggle" href="' . get_permalink($menu_item->object_id) . '" id="navbarDropdown' . $menu_item->ID . '" role="button" aria-haspopup="true" aria-expanded="false">' . $menu_item->title . '</a>';
                            echo '<div class="dropdown-menu" aria-labelledby="navbarDropdown' . $menu_item->ID . '">';
                            // Output sub-menu items
                            foreach ($menu_items as $sub_menu_item) {
                                if ($sub_menu_item->menu_item_parent == $menu_item->ID) {
                                    echo '<a class="dropdown-item" href="' . get_permalink($sub_menu_item->object_id) . '">' . $sub_menu_item->title . '</a>';
                                }
                            }
                            echo '</div>';
                            echo '</div>';
                        } else {
                            echo '<a href="' . get_permalink($menu_item->object_id) . '" class="' . $class . '">' . $menu_item->title . '</a>';
                        }
                    }
                }

                // Function to check if a menu item has children
                function has_children($menu_items, $id) {
                    foreach ($menu_items as $menu_item) {
                        if ($menu_item->menu_item_parent == $id) {
                            return true;
                        }
                    }
                    return false;
                }
                ?>
            </div>
        </div>
    </div>
</nav>

<script>
    // Add hover functionality for dropdown menus
    document.querySelectorAll('.dropdown').forEach(function(dropdown) {
        var dropdownToggle = dropdown.querySelector('.dropdown-toggle');

        dropdown.addEventListener('mouseenter', function() {
            this.classList.add('show');
        });

        dropdown.addEventListener('mouseleave', function() {
            this.classList.remove('show');
        });

        dropdownToggle.addEventListener('click', function(event) {
            event.stopPropagation(); // Prevent the default click behavior of the dropdown toggle
        });
    });
</script>






      </div>
      </div>

   </header>

	<div id="content" class="site-content">
		<div id="primary" class="content-area">
			<main id="main" class="site-main">
