
<?php 
/*
    Template Name: MINISTÈRE TUTELLE
*/
get_header();
?>

<section class="institution-1">
    <div class="container">
        <div class="head-institution">
            <div class="title-instution">
                <h1><?php the_field( 'titre' ); ?></h1>
            </div>
                <div class="scroller">
                    <a href="#institution-2">
                    <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/image/Groupe 571.svg" alt="">
                </a>
            </div>
        </div>
    </div>
</section>
<section class="institution-2" id="institution-2">
    <div class="container">
        <div class="row">
            <div class="col-md-7">
                <div class="who">
                    <div class="content-who">
                        <div class="title-who">
                            <h2><?php the_field( 'titre_qui' ); ?></h2>
                        </div>
                        <div class="subtitle-who">
                            <span><?php the_field( 'sous_titre_qui' ); ?></span>
                        </div>
                        <div class="text-who">
                            <p><?php the_field( 'description' ); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-5">
            <?php if ( get_field( 'image' ) ) : ?>
	<img src="<?php the_field( 'image' ); ?>" alt="" width="100%"/>
<?php endif ?>
            </div>
        </div>
    </div>
</section>

<section class="institution-3">
    <div class="container">
        <div class="holder-title">
            <h2><?php the_field( 'titre_actt' ); ?></h2>
            <div class="show-more">
               <a href="<?php the_field( 'lien' ); ?>">
                  <span><?php the_field( 'texte_lien' ); ?></span>
                  <img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/image/arrow.svg" alt="Show more" width="45px">
               </a>
            </div>
            
         </div>
         <div class="subtitle-institution-3">
            <p><?php the_field( 'sous_titre_actt' ); ?>
            </p>
        </div>
        <div class="news">
    <div class="row">
        <?php
        // Define the arguments for the query
        $args = array(
            'post_type'      => 'actualitees',
            'post_status'    => 'publish',
            'order'          => 'ASC',
            'posts_per_page' => 3 // Number of posts to display
        );

        // Query the posts
        $query = new WP_Query($args);

        // Counter variable
        $count = 0;

        // Check if there are posts
        if ($query->have_posts()) :
            // Loop through each post
            while ($query->have_posts()) : $query->the_post();
                $count++; // Increment counter
                $categories_act = get_the_terms(get_the_ID(), 'categorie_actualites');
        ?>
                <div class="<?php echo ($count == 3) ? 'col-md-6' : 'col-md-3'; ?>">
                    <div class="card <?php echo ($count == 3) ? 'custom-padding' : ''; ?>">
                        <a href="<?php the_permalink(); ?>">
                        <?php if ( get_field( 'image_petite' ) ) : ?>
                                <img src="<?php the_field( 'image_petite' ); ?>"  width="100%" class="card-img-top"/>
                            <?php endif ?>
                           
                            <div class="card-body">
                                <div class="category">
                                    <?php if ($categories_act) : ?>
                                        <?php foreach ($categories_act as $category) : ?>
                                            <li><a href="<?php echo get_term_link($category); ?>"><?php echo $category->name; ?></a></li>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                                <h5 class="card-title"><?php the_title(); ?></h5>
                                <p class="card-text"><?php the_field('description'); ?></p>
                                <a href="<?php the_permalink(); ?>" class="btn">Read all</a>
                            </div>
                        </a>
                    </div>
                </div>
        <?php
            endwhile;
            wp_reset_postdata(); // Reset post data
        else :
            // If no posts found
            echo '<p>No posts found</p>';
        endif;
        ?>
    </div>
</div>


    </div>
</section>

<?php 

get_footer();
