<?php
/*
    Template Name: Publications AJAX
*/
$step = isset($_GET["step"]) ? $_GET["step"] : 1;
$posts_per_page = isset($_GET["posts_per_page"]) ? $_GET["posts_per_page"] : 10;
$category = isset($_GET["category"]) ? $_GET["category"] : "";

if ($category != "") {
    $args = array(
        'post_type'      => 'puublications',
        'post_status'    => 'publish',
        'order'          => 'DESC',
        'tax_query'      => array(
            array (
                'taxonomy' => 'categorie_pub',
                'field' => 'slug',
                'terms' => $category,
            )
        ),
        'posts_per_page' => $posts_per_page,
        'paged'          => $step
    );
} else {
    $args = array(
        'post_type'      => 'puublications',
        'post_status'    => 'publish',
        'order'          => 'DESC',
        'posts_per_page' => $posts_per_page,
        'paged'          => $step
    );
}

$loop = new WP_Query($args);
?>

<div class="container">
    <div class="row">
        <?php 
        $i = 0;
        while ($loop->have_posts()) {
            $i++;
            $loop->the_post();

            // Get the category name
            $categories = get_the_terms(get_the_ID(), 'categorie_pub');
            $category_name = '';
            if (!empty($categories)) {
                $category_name = $categories[0]->name;
            }
        ?>
        <div class="col-md-6">
            <div class="item-news-big">
                <a href="<?php the_permalink(); ?>">
                    <div class="item-news-big-img">
                    <?php if ( get_field( 'image_slide' ) ) : ?>
                            <img src="<?php the_field( 'image_slide' ); ?>" width="100%"/>
                        <?php endif ?>
                        <div class="text-overlay">
                            <div class="category">
                                <li><?php echo $category_name; ?></li>
                            </div>
                            <div class="title-item-news-big">
                                <h3><?php the_title() ?></h3>
                            </div>
                            <div class="text-item-news-big pubspan">
                                <span><?php the_field('description'); ?></span>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        </div>
        <?php
            }
            wp_reset_postdata();
        ?>
    </div>
</div>
